/*------------------------------------------------------------------------------*
 * File Name: ImpWizDataPattern.h												*
 * Creation: Jacky 12/14/2003													*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	 Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL	                            *
 *   Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME                                *
 *   Jacky 12/14/03 v7.5781 DEFINE_SOME_NEW_MEMBER                              *
 *   Jacky 12/21/03 v7.5784 NOT_NEED_PAGE_TO_CALL                               *
 *	 Danice 12/23/03 v7.5786 SAVE_CHANGE										*
 *	 Jason 12/26/03 v7.5789 USE_M_CTRLGRID										*
 *   Danice 12/26/03 v7.5789 UPDATE_DIRECTLY									*
 *   Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER						*
 *   Danice 2/12/04 v8.0819 CHANGE_GRID_TO_CLASS								*
 *   Danice 2/16/04 v8.0821 ADD_SOME_ACCESS_FUNCTION							*
 *   Danice 2/20/04 v8.0822 INIT_GRID											*
 *   Danice 2/23/04 v8.0824 REFRESH_PREVIEW_WHEN_CHANGE							*
 *   EJP 02-26-2004 v7.5828 ONLY_CREATE_WKS_CTRL_ONCE							*
 *   Danice 3/1/04 v8.0828 PAGE_INIT_ONCE										*
 *   Danice 3/29/04 v8.0844b CHANGE_PARA_ORDER_ROW_COL							*
 *	Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT				*
 *	TD 09-25-2008 QA80-12260 FLEXGRID_EVENT_HANDLER_CRASH						*
 *	Sim 11-01-2008 v8.0964c QA80-12260 FIX_TYPE_FIRST_LETTER_IN_TYPE_COMBO_LIST_NOT_UPDATE_DIALOG
 *------------------------------------------------------------------------------*/

 //#define ON_PAGE_CHECK_BIN_PATTERN			if(!IS_SHOW_BIN_PATTERN_PAGE) return FALSE;
#define ON_PAGE_CHECK_BIN_PATTERN			if(!IS_SHOW_BIN_PATTERN_PAGE) return FALSE;

// These need to be localized
/// ML 11/25/2003 BITWISE_OR_SEPARATED_TRANSLATION
//#define BINIMP_DATA_TYPE_TOKENS		"Integer|Unsigned Integer|Real|String"
//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
//#define BINIMP_DATA_TYPE_TOKENS		_LB("Integer|Unsigned Integer|Real|String")
#define BINIMP_DATA_TYPE_TOKENS		_L("Integer|Unsigned Integer|Real|String")
//-----
/// end BITWISE_OR_SEPARATED_TRANSLATION

enum {
	GRIDCOL_BINPARAM_COLUMN = 0,
	GRIDCOL_BINPARAM_TYPE,
	GRIDCOL_BINPARAM_SIZE,
	GRIDCOL_BINPARAM_COUNT,
	GRIDCOL_TOTAL_COLS
};

//--- CPY 2/10/04 CHANGE_GRID_TO_CLASS
// we need to use class to represent all vsFlexGrid, should not have GetActiveXControl anywere in importwizard codes
class BinDataElementsList : public GridListControl
{
public:
	BinDataElementsList(); 

	void Init(int nID, WndContainer& dlg);
	
	void OnGridBeforeEdit(int nRow, int nCol);
	
	void UpdateDataColumnOffsets(int iEditTextRow);
	
	void UpdateParamVectorsFromGrid(int iEditTextRow, int iEditTextCol, vector<BYTE>& vParamType, vector<WORD>& vParamCount, vector<WORD>& vParamSize, int& iNumColumns);
	
	void UpdateGridFromParamVectors(const vector<BYTE>& vParamType, const vector<WORD>& vParamCount, const vector<WORD>& vParamSize);

	void AddRowToGrid();

	void UpdateDataViewColoring(int& iTotal);

	void GetRowAndCol(int& iRow, int& iCol);
	
	void OnGridComboCloseUp();
};
//--- end CHANGE_GRID_TO_CLASS

class ImpWizDataPatternPage : public ImpWizardPage
{
// Constructor for ImpWizHeaderBytesPage class, use parent constructor
//ImpWizDataPatternPage(int nID) : ImpWizardPage(nID) {}
public:
	
	EVENTS_BEGIN
		
		//PAGE_ON_IS_SHOW(OnIsShowBinary)		///Danice 12/25/03 v7.5788 NOTUSE_SHOW
		
		PAGE_ON_INIT(OnInit_BinPattern)
		PAGE_ON_ACTIVE(OnActivate_BinPattern)
		PAGE_ON_KILLACTIVE(OnKillActive_BinPattern)
		ON_BN_CLICKED(IDC_BIW_DATAPATERN_HEX, OnClickDataView_BinPattern)
		ON_CBN_SELCHANGE(IDC_BIW_DATAPATERN_PARAMS, OnSelChangeHeaderVariable_BinPattern)
		ON_BN_CLICKED(IDC_DATAPATTERN_INSERT, OnClickInsertRow_BinPattern)
		ON_BN_CLICKED(IDC_DATAPATTERN_DELETE, OnClickDeleteRow_BinPattern)
		ON_GRID_BEFORE_EDIT(IDC_BIW_DATAPATERN_PATERN_GRID, OnBeforeEditGrid_BinPattern)
		/// TD 09-25-2008 QA80-12260 FLEXGRID_EVENT_HANDLER_CRASH
		//ON_GRID_CHANGE_EDIT(IDC_BIW_DATAPATERN_PATERN_GRID, OnChangeEditGrid_BinPattern)
		///---Sim 11-01-2008 v8.0964c QA80-12260 FIX_TYPE_FIRST_LETTER_IN_TYPE_COMBO_LIST_NOT_UPDATE_DIALOG
		//ON_GRID_AFTER_EDIT(IDC_BIW_DATAPATERN_PATERN_GRID, OnChangeEditGrid_BinPattern)
		ON_GRID_AFTER_EDIT(IDC_BIW_DATAPATERN_PATERN_GRID, OnAfterEditGrid_BinPattern)
		ON_GRID_CHANGE_EDIT(IDC_BIW_DATAPATERN_PATERN_GRID, OnChangeEditGrid_BinPattern)
		///---END v8.0964c QA80-12260 FIX_TYPE_FIRST_LETTER_IN_TYPE_COMBO_LIST_NOT_UPDATE_DIALOG
		/// end FLEXGRID_EVENT_HANDLER_CRASH
		ON_GRID_COMBO_CLOSEUP(IDC_BIW_DATAPATERN_PATERN_GRID, OnGridComboCloseUp_BinPattern)
		
		ON_BN_CLICKED(IDC_IW_KEEP_COL_FORMAT, OnClickKeepColFormat) // Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
		
	EVENTS_END
	
protected :
//Events handles

	///Danice 12/25/03 v7.5788 NOTUSE_SHOW
	DWORD    OnShowStatus(DWORD InternalStatus);
	///END NOTUSE_SHOW

	//--------------------------------------------------------------------------
	// UpdateWksCtrl
	//
	// Call this function to update the worksheet control on the specified page.
	//--------------------------------------------------------------------------
	void UpdateWksCtrl(int iWizPageID);
	
	void UpdatePreview(int iWizPageID);

	int BinHeader_GetParamValAsStr(int nType, int nOffset, int nSize, string &strVal);

	BOOL GetBinHdrParamListStr(string &str, int nIndex, BOOL bWithValue=true);
	
	BOOL OnInit_BinPattern();    ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	BOOL OnActivate_BinPattern();       ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	void iw_SetRichEditFont(int iCtrl, int iFont);
	
	BOOL OnKillActive_BinPattern();          ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	BOOL OnClickDataView_BinPattern(Control ctrl);    ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	BOOL OnBeforeEditGrid_BinPattern(Control ctrl, int nRow, int nCol, BOOL *pCancel);  ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	///---Sim 11-01-2008 v8.0964c QA80-12260 FIX_TYPE_FIRST_LETTER_IN_TYPE_COMBO_LIST_NOT_UPDATE_DIALOG
	//BOOL OnChangeEditGrid_BinPattern(Control ctrl, int nRow, int nCol);  ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME /// TD 09-25-2008 QA80-12260 FLEXGRID_EVENT_HANDLER_CRASH (Changed Prototype)
	BOOL OnAfterEditGrid_BinPattern(Control ctrl, int nRow, int nCol);  ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME /// TD 09-25-2008 QA80-12260 FLEXGRID_EVENT_HANDLER_CRASH (Changed Prototype)
	
	BOOL OnChangeEditGrid_BinPattern(Control ctrl);
	///---END v8.0964c QA80-12260 FIX_TYPE_FIRST_LETTER_IN_TYPE_COMBO_LIST_NOT_UPDATE_DIALOG
	
	void OnGridComboCloseUp_BinPattern(Control ctrl, int nRow, int nCol, BOOL* pFinishEdit);  ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	void BinPattern_UpdateDataViewColoring();
	
	BOOL OnClickInsertRow_BinPattern(Control ctrl); ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	BOOL OnClickDeleteRow_BinPattern(Control oCntrl); ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	BOOL BinPattern_UpdateDataView();  
	
	BOOL OnSelChangeHeaderVariable_BinPattern(Control ctrl);  ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	void BinPattern_UpdateDataColumnOffsetsInGrid(int iEditTextRow);
	
	void BinPattern_UpdateGridFromParamVectors();
	
	void BinPattern_UpdateParamVectorsFromGrid(int iEditTextRow, int iEditTextCol);
	
	void BinCols_AddRowToGrid();
	
	BOOL OnClickKeepColFormat(Control ctrl); // Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
	
private:
	//--- CPY 2/10/04 CHANGE_GRID_TO_CLASS
	// please remove m_ctrlGrid when codes clean up
	// please remove m_ctrlGrid when codes clean up
	// please remove m_ctrlGrid when codes clean up
	//--- end CHANGE_GRID_TO_CLASS	
		///Jacky 12/14/03 v7.5781 DEFINE_SOME_NEW_MEMBER 
		//Control 	m_ctrlGrid; 	///Danice CHANGE_GRID_TO_CLASS
		//Control 	m_octrl;	///Jason 12/26/03 v7.5789 USE_M_CTRLGRID
	//--- CPY 2/10/04 CHANGE_GRID_TO_CLASS
	// please remove m_ctrlGrid when codes clean up
	// please remove m_ctrlGrid when codes clean up
	// please remove m_ctrlGrid when codes clean up
	// please remove m_ctrlGrid when codes clean up
	// please remove m_ctrlGrid when codes clean up
	// please remove m_ctrlGrid when codes clean up
	// please remove m_ctrlGrid when codes clean up
		BinDataElementsList m_dataElements;
	//--- end CHANGE_GRID_TO_CLASS	
	Control 	m_ctrlParamText;
	Control 	m_ctrlValueText;
	
	ComboBox 	m_comboParams;
	
	WorksheetControl m_wc;
	RichEdit 	m_reDataView;
	Edit 		m_editValue;
	
	Button m_chkKeepColFormat; // Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
	
	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//ASCIMP 	m_ascimp;
	//BINIMP	m_pBinimp;
	BINIMP* 	m_pBinimp;
	///END NEW_ACCESS_METHOD_GET_POINTER
	
	StringArray m_saHdrParamName;
	vector<int>	m_vHdrParamType;
	vector<int>	m_vHdrParamOffset;
	vector<int>	m_vHdrParamSize;
	
	///End DEFINE_SOME_NEW_MEMBER

};